import { Action } from 'redux-actions';

import { IOffice } from 'client/common/types/agencies';
import { LoadingState } from 'client/common/types/common';

export interface IFormData {
    name: string;
    description: string;
    directBudget: number | null;
    site: string;
    offices: IOffice[];
}

export interface IFormDataChanges {
    name?: string;
    description?: string;
    directBudget?: number | null;
    site?: string;
}

export type TFormOfficeChanges = Partial<IOffice>;

export enum AgencyFormMode {
    hidden = 'hidden',
    editing = 'editing',
    preview = 'preview'
}

export interface IAgencyState {
    showProductsCard: {
        market: boolean;
        direct: boolean;
        metrika: boolean;
        toloka: boolean;
        dialogs: boolean;
    };
    form: {
        mode: AgencyFormMode;
        data: IFormData | null;
        sendingState: LoadingState;
    };
    offices: {
        selectedId: number | null;
    };
}

export enum ActionTypes {
    START_EDITING = '[agency] start editing',
    CANCEL_EDITING = '[agency] cancel editing',
    CHANGE_FORM_DATA = '[agency] change form data',
    CHANGE_FORM_OFFICE = '[agency] change form office',
    ADD_FORM_OFFICE = '[agency] add form office',
    REMOVE_FORM_OFFICE = '[agency] remove form office',
    SHOW_FORM_PREVIEW = '[agency] show form preview',
    HIDE_FORM_PREVIEW = '[agency] hide form preview',
    SENDING_START = '[agency] start sending',
    SENDING_FAIL = '[agency] sending fail',
    SENDING_SUCCESS = '[agency] sending success',
    SELECT_OFFICE = '[agency] select office',
    SHOW_OR_HIDE_PRODUCT_CARD = '[agency] show or hide products card'
}

export interface IStartEditingPayload {
    initialData: IFormData;
}

// tslint:disable-next-line:no-empty-interface
export interface ICancelEditingPayload {}

export interface IChangeFormDataPayload {
    changes: IFormDataChanges;
}

export interface IChangeFormOfficePayload {
    index: number;
    changes: TFormOfficeChanges;
}

export interface IAddFormOfficePayload {
    office: IOffice;
}

export interface IRemoveFormOfficePayload {
    index: number;
}

// tslint:disable-next-line:no-empty-interface
export interface IShowFormPreviewPayload {}

// tslint:disable-next-line:no-empty-interface
export interface IHideFormPreviewPayload {}

// tslint:disable-next-line:no-empty-interface
export interface ISendingStartPayload {}

// tslint:disable-next-line:no-empty-interface
export interface ISendingFailPayload {}

// tslint:disable-next-line:no-empty-interface
export interface ISendingSuccessPayload {}

export interface ISelectOfficePayload {
    officeId: number;
}

export interface IShowOrHideProductsCardPayload {
    certificateName: 'direct'|'metrika'|'market'|'toloka'|'dialogs';
    showProductsCard: boolean;
}

export type IAgencyPayload =
    IStartEditingPayload |
    ICancelEditingPayload |
    IChangeFormDataPayload |
    IChangeFormOfficePayload |
    IAddFormOfficePayload |
    IRemoveFormOfficePayload |
    IShowFormPreviewPayload |
    IHideFormPreviewPayload |
    ISendingStartPayload |
    ISendingFailPayload |
    ISendingSuccessPayload |
    ISelectOfficePayload;

export interface IStartEditingAction extends Action<IStartEditingPayload> {
    type: ActionTypes.START_EDITING;
}

export interface ICancelEditingAction extends Action<ICancelEditingPayload> {
    type: ActionTypes.CANCEL_EDITING;
}

export interface IChangeFormDataAction extends Action<IChangeFormDataPayload> {
    type: ActionTypes.CHANGE_FORM_DATA;
}

export interface IChangeFormOfficeAction extends Action<IChangeFormOfficePayload> {
    type: ActionTypes.CHANGE_FORM_OFFICE;
}

export interface IAddFormOfficeAction extends Action<IAddFormOfficePayload> {
    type: ActionTypes.ADD_FORM_OFFICE;
}

export interface IRemoveFormOfficeAction extends Action<IRemoveFormOfficePayload> {
    type: ActionTypes.REMOVE_FORM_OFFICE;
}

export interface IShowFormPreviewAction extends Action<IShowFormPreviewPayload> {
    type: ActionTypes.SHOW_FORM_PREVIEW;
}

export interface IHideFormPreviewAction extends Action<IHideFormPreviewPayload> {
    type: ActionTypes.HIDE_FORM_PREVIEW;
}

export interface ISendingStartAction extends Action<ISendingStartPayload> {
    type: ActionTypes.SENDING_START;
}

export interface ISendingFailAction extends Action<ISendingFailPayload> {
    type: ActionTypes.SENDING_FAIL;
}

export interface ISendingSuccessAction extends Action<ISendingSuccessPayload> {
    type: ActionTypes.SENDING_SUCCESS;
}

export interface ISelectOfficeAction extends Action<ISelectOfficePayload> {
    type: ActionTypes.SELECT_OFFICE;
}
export interface IShowOrHideProductsCardAction extends Action<IShowOrHideProductsCardPayload> {
    type: ActionTypes.SHOW_OR_HIDE_PRODUCT_CARD;
}
