import { combineReducers, createStore } from 'redux';
import { devToolsEnhancer } from 'redux-devtools-extension/developmentOnly';

import agenciesReducer from './agencies/reducer';
import agencyReducer from './agency/reducer';
import popupsReducer from './popups/reducer';
import sidebarReducer from './sidebar/reducer';

import { IAgenciesState } from './agencies/types';
import { IAgencyState } from './agency/types';
import { IPopupsState } from './popups/types';
import { ISidebarState } from './sidebar/types';

export interface IAppState {
    agencies: IAgenciesState;
    agency: IAgencyState;
    popups: IPopupsState;
    sidebar: ISidebarState;
}

const reducers = {
    agencies: agenciesReducer,
    agency: agencyReducer,
    popups: popupsReducer,
    sidebar: sidebarReducer
};

function configureStore(initialState = {}) {
    const rootReducer = combineReducers<IAppState>(reducers);

    return createStore(rootReducer, initialState, devToolsEnhancer({}));
}

export default configureStore;
