import { handleAction } from 'redux-actions';

import { ActionTypes, IPopupsState, ISetContainerRefAction } from './types';

const initialState: IPopupsState = { containerRef: { current: null } };

function setContainerRef(state: IPopupsState, { payload }: ISetContainerRefAction): IPopupsState {
    return Object.assign({}, state, { containerRef: payload.ref });
}

export default handleAction(ActionTypes.SetContainerRef, setContainerRef, initialState);
