import { Action } from 'redux-actions';

export interface TContainerRef {
    current: null | HTMLDivElement;
}

export interface IPopupsState {
    containerRef: TContainerRef;
}

export enum ActionTypes {
    SetContainerRef = '[popups] Set container ref'
}

export interface ISetContainerRefPayload {
    ref: TContainerRef;
}

export interface ISetContainerRefAction extends Action<ISetContainerRefPayload> {
    type: ActionTypes.SetContainerRef;
    payload: ISetContainerRefPayload;
}

export type TPopupsAction = ISetContainerRefAction;
