import { handleActions } from 'redux-actions';

import { ActionTypes, IPushMenuItemAction, ISidebarPayload, ISidebarState } from './types';

const initialState: ISidebarState = { isOpen: false, menuIndexChain: [] };

function toggleSidebar(state: ISidebarState): ISidebarState {
    return Object.assign({}, state, { isOpen: !state.isOpen });
}

function pushMenuItem(state: ISidebarState, action: IPushMenuItemAction): ISidebarState {
    const menuIndexChain = [...state.menuIndexChain, action.payload.item];

    return Object.assign({}, state, { menuIndexChain });
}

function popMenuItem(state: ISidebarState): ISidebarState {
    const { menuIndexChain } = state;

    const chain = menuIndexChain.slice(0, menuIndexChain.length - 1); // FIXME: разобраться, когда это нужно делать (для страниц, которые есть сейчас, включая общий список, работать будет нормально)

    if (chain.length > 0) {
        chain.pop();
    }

    return Object.assign({}, state, { menuIndexChain: chain });
}

export default handleActions<ISidebarState, ISidebarPayload>({
    [ActionTypes.TOGGLE_SIDEBAR]: toggleSidebar,
    [ActionTypes.PUSH_MENU_ITEM]: pushMenuItem,
    [ActionTypes.POP_MENU_ITEM]: popMenuItem
}, initialState);
