import { Action } from 'redux-actions';

export interface ISidebarState {
    isOpen: boolean;
    menuIndexChain: number[];
}

export enum ActionTypes {
    TOGGLE_SIDEBAR = '[sidebar] toggle sidebar',
    PUSH_MENU_ITEM = '[sidebar] push menu item',
    POP_MENU_ITEM = '[sidebar] pop menu item'
}

// tslint:disable-next-line
export interface ISidebarPayload {}

export interface IToggleSidebarAction extends Action<ISidebarPayload> {
    type: ActionTypes.TOGGLE_SIDEBAR;
}

export interface IPushMenuItemPayload {
    item: number;
}

export interface IPushMenuItemAction extends Action<IPushMenuItemPayload> {
    type: ActionTypes.PUSH_MENU_ITEM;
    payload: IPushMenuItemPayload;
}

export interface IPopMenuItemAction extends Action<ISidebarPayload> {
    type: ActionTypes.POP_MENU_ITEM;
}

export type TSidebarAction =
    | IToggleSidebarAction
    | IPushMenuItemAction
    | IPopMenuItemAction;
