import {
    CertificateType,
    IAgenciesConfig,
    IAgency,
    IOffice
} from 'client/common/types';

import mds from 'utils/mds';

export function getLogo(rawLogo: string, config: IAgenciesConfig, size: string = 'l') {
    const logo = rawLogo || config.agency.logo.default;

    return mds(logo, `a_logo_${size}`);
}

export function getFilledEmail(offices: IOffice[]) {
    const firstOfficeWithFilledEmail = offices.find(office => Boolean(office.email));

    return firstOfficeWithFilledEmail ? firstOfficeWithFilledEmail.email : null;
}

export function hasCertificate(certificates: IAgency['certificates'], type: CertificateType) {
    return certificates.some(certificate => {
        return certificate.code === type;
    });
}
