export function getCookie(name: string) {
    name = name.replace(/([.$?*|{}()[]\/+^])/g, '\\$1');

    const matches = document.cookie.match(
        new RegExp(`(?:^|; )${name}=([^;]*)`)
    );

    return matches ? decodeURIComponent(matches[1]) : undefined;
}

export function setCookie(name: string, value: string) {
    document.cookie = `${encodeURIComponent(name)}=${encodeURIComponent(value)}`;
}
