// tslint:disable-next-line
type TCallback = (...args: any[]) => any;

interface IDebounced extends TCallback {
    clear: () => void;
    flush: () => void;
}

function debounce(func: TCallback, wait: number, immediate: boolean) {

    let timeout: number | null;
    // tslint:disable-next-line
    let args: any[] | null;
    let context: object | null;
    let timestamp: number;
    // tslint:disable-next-line
    let result: any;

    if (wait === null) {
        wait = 100;
    }

    function later() {
        const last = Date.now() - timestamp;

        if (last < wait && last >= 0) {
            timeout = window.setTimeout(later, wait - last);
        } else {
            timeout = null;
            if (!immediate) {
                result = func.apply(context, args);
                context = null;
                args = null;
            }
        }
    }

    const debounced = function (...tmpArgs) {
        context = this;
        args = tmpArgs;
        timestamp = Date.now();
        const callNow = immediate && !timeout;

        if (!timeout) {
            timeout = window.setTimeout(later, wait);
        }

        if (callNow) {
            result = func.apply(context, args);
            args = null;
            context = null;
        }

        return result;
    } as IDebounced;

    debounced.clear = function () {
        if (timeout) {
            clearTimeout(timeout);
            timeout = null;
        }
    };

    debounced.flush = function () {
        if (timeout) {
            result = func.apply(context, args);
            args = null;
            context = null;

            clearTimeout(timeout);
            timeout = null;
        }
    };

    return debounced;
}

// Adds compatibility for ES modules
export default debounce;
