interface TReadyStyle {
    background?: string;
    color?: string;
}

type TStyleField = keyof TReadyStyle;

export interface TCustomStyle {
    target: string;
    field: TStyleField;
    value: string;
}

export function s(target: string, customStyles?: TCustomStyle[], fields?: TStyleField[]) {

    return customStyles?.filter(style => style.target === target && (!fields || fields.includes(style.field))).reduce((acc: TReadyStyle, cur) => {
        acc[cur.field] = cur.value;

        return acc;
    }, {});
}
