import { IResponseError } from '../@types/fetch';

/**
 * Заменяет html мнемоники на символы юникода
 * @param {Object} htmlMappings
 * @param {String} string
 * @returns {String}
 */
export function replaceHtmlEntities(
    htmlMappings: { [key: string]: string },
    string: string
) {
    const regex = new RegExp(Object.keys(htmlMappings).join('|'), 'gi');

    return string && string.replace(regex, entity => {
        entity = entity.toLowerCase();

        return htmlMappings[entity];
    });
}

export function splitIntoTwoArrays<T>(arr: T[]): [T[], T[]] {
    const half = Math.ceil(arr.length / 2);

    return [
        arr.slice(0, half),
        arr.slice(half)
    ];
}

export function getErrorCode(err: IResponseError[] | IResponseError, internal = false) {
    const path = Array.isArray(err) ? '0.internalCode' : 'internalCode';
    const internalCode = getProp(err, path, '500');

    return internal ? String(internalCode) : Number(internalCode.slice(0, 3));
}

// tslint:disable:no-any
export function getProp(
    object: any,
    path: string | Array<string | number>,
    defaultValue?: any
): any {
    if (object === undefined || object === null) {
        return defaultValue;
    }

    const _path = Array.isArray(path)
        ? path
        : path.split('.').filter((part: any) => part.length);

    if (!_path.length) {
        return object;
    }

    const key = _path.shift() as string;

    return getProp(object[key], _path, defaultValue);
}

export function isElementVisible(el: Element) {
    const rect = el.getBoundingClientRect();
    const { top, bottom } = rect;

    return top >= 0 && bottom <= window.innerHeight;
}

export function getUniqueValues<T>(array: T[]) {
    return array.filter((item, index, arr) => arr.indexOf(item) === index);
}
