import {
    I18NFunctionArguments,
    I18NParams,
    ITranslations,
    TI18NFunc,
    TI18NFunction
} from './types';

interface IDefaultTranslation {
    default: ITranslations;
}

export default function createI18NFunction({ default: i18n }: IDefaultTranslation): TI18NFunction {
    return function ({ keyset, key, params }: I18NFunctionArguments<I18NParams>) {
        const content = (i18n[keyset] && i18n[keyset][key]) || '';

        if (params) {
            return (content as TI18NFunc)(params);
        }

        return content as string;
    };
}
