import { I18NParams } from '../types';

export function gender(params: I18NParams) {
    return params[params.gender!];
}

export function plural(params: I18NParams) {
    const count = isNaN(parseInt(params.count as string, 10)) ? 0 : params.count;

    return count === 1
        ? params.one
        : params.some;
}

/* eslint-disable-next-line camelcase */
export function plural_adv(params: I18NParams) {
    const count = isNaN(parseInt(params.count as string, 10)) ? 0 : params.count;

    if (count === 0) {
        return params.none;
    }

    return plural({
        'count': params.count,
        'one': params.one,
        'some': params.some
    });
}

export function toggle(params: I18NParams) {
    return params.condition ? params.true : params.false;
}
