import { I18NParams } from '../types';

export function gender(params: I18NParams) {
    return params[params.gender!];
}

/* eslint-disable complexity */
export function plural(params: I18NParams) {
    const count = isNaN(parseInt(params.count as string, 10)) ? 0 : params.count as number;
    const lastNumber = count % 10;
    const lastNumbers = count % 100;

    const several = ((lastNumber > 1 && lastNumber < 5) && (lastNumbers < 10 || lastNumbers > 20)
        ? params.some
        : params.many
    );

    return (lastNumber === 1 && lastNumbers !== 11)
        ? params.one
        : several;
}
/* eslint-enable complexity */

/* eslint-disable-next-line camelcase */
export function plural_adv(params: I18NParams) {
    const count = isNaN(parseInt(params.count as string, 10)) ? 0 : params.count;

    if (count === 0) {
        return params.none;
    }

    return plural({
        'count': params.count,
        'one': params.one,
        'some': params.some,
        'many': params.many
    });
}

export function toggle(params: I18NParams) {
    return params.condition ? params.true : params.false;
}
