import createI18NFunction from './create';
import { I18NParams } from './types';

const translations = require(`./i18n.${process.env.BEM_LANG}.ts`);

const i18n = createI18NFunction(translations);

export default i18n;

export function bindKeyset(keyset: string) {
    return function (key: string, params?: I18NParams) {
        return i18n({ keyset, key, params });
    };
}
