export interface ITranslations {
    [keyset: string]: {
        [key: string]: string | TI18NFunc;
    };
}

export type TI18NFunc = (params: I18NParams) => string;

export interface I18NParams {
    [param: string]: undefined | string | number;
}

export interface I18NFunctionArguments<Params extends I18NParams> {
    keyset: string;
    key: string;
    params?: Params;
}

export type TI18NFunction = (args: I18NFunctionArguments<I18NParams>) => string;
