import url from 'url';

import i18n from 'utils/i18n';

type TService = string[][];

interface IServices {
    [key: string]: TService;
}

interface IServiceUrls {
    [key: string]: {
        [key: string]: string
    };
}

export interface IHeaderMenuItem {
    name: string;
    current: boolean;
    url: string;
}

const SERVICES_VIEW: IServices = {
    ru: [
        ['company', 'blog', 'vacancies', 'tech', 'adv'],
        ['events', 'science', 'edu']
    ],
    com: [
        ['company', 'vacancies', 'tech', 'adv', 'events']
    ],
    'com.tr': [
        ['company', 'blog', 'vacancies', 'tech', 'adv']
    ],
    by: [
        ['company', 'blog', 'vacancies', 'adv']
    ],
    kz: [
        ['company', 'blog', 'vacancies', 'adv']
    ],
    cn: [
        ['adv']
    ]
};

const SERVICES_URL: IServiceUrls = {
    company: {
        ru: '//yandex.ru/company/',
        com: '//yandex.com/company/',
        kz: '//yandex.kz/company/',
        by: '//yandex.by/company/',
        'com.tr': '//yandex.com.tr/company/'
    },
    vacancies: {
        ru: '//yandex.ru/jobs/',
        com: '//yandex.com/jobs',
        kz: '//yandex.ru/jobs/',
        by: '//yandex.by/jobs/',
        'com.tr': '//yandex.com.tr/jobs'
    },
    tech: {
        ru: '//tech.yandex.ru',
        com: '//tech.yandex.com',
        kz: '//tech.yandex.ru',
        by: '//tech.yandex.ru',
        'com.tr': '//tech.yandex.com.tr'
    },
    events: {
        ru: '//events.yandex.ru',
        com: '//events.yandex.com/events/',
        kz: '//events.yandex.ru',
        by: '//events.yandex.ru',
        'com.tr': '//events.yandex.com/events/'
    },
    science: {
        ru: '//research.yandex.ru',
        com: '//events.yandex.com/research/',
        kz: '//research.yandex.ru',
        by: '//research.yandex.ru',
        'com.tr': '//events.yandex.com/research/'
    },
    edu: {
        ru: '//academy.yandex.ru',
        kz: '//academy.yandex.ru',
        by: '//academy.yandex.ru'
    },
    blog: {
        ru: '//yandex.ru/blog/company',
        kz: '//yandex.kz/blog/company',
        by: '//yandex.by/blog/company',
        com: '//yandex.com/blog/company',
        'com.tr': '//yandex.com.tr/blog/company'
    }
};

export function getHeaderMenu(region: string, homeUrl: string): IHeaderMenuItem[][] {
    const view = SERVICES_VIEW[region];

    return view.map(level => {
        return level.map(serviceId => {
            const isCurrent = serviceId === 'adv';

            const name = i18n({
                keyset: 'header',
                key: `service.${serviceId}`
            });

            return {
                name,
                current: isCurrent,
                url: isCurrent ? homeUrl : SERVICES_URL[serviceId][region]
            };
        });
    });
}

export function addMenuParam(src: string, isOpen: boolean) {
    const urlObject = url.parse(src, true);
    const query = isOpen ? { menu: 'open' } : {};

    urlObject.search = undefined;
    urlObject.query = Object.assign(urlObject.query, query);

    return url.format(urlObject);
}
