/**
 * Превращает ссылку на /orig изображение в ссылку на необходимый тамбнэйл
 * @param {string} orig - ссылка на orig (напр. https://avatars.mdst.yandex.net/get-adv/.../orig)
 * @param {string} alias - название необходимого алиаса тамбнэйла (напр. a_logo_m)
 * @returns {string}
 */
export default function mds(orig: string, alias: string) {
    const isOrigString = orig && typeof orig === 'string';
    const isAliasString = alias && typeof alias === 'string';

    if (!isOrigString || !isAliasString) {
        return orig;
    }

    return orig.replace(/(\/(get-adv|get-yablogs)\/\S+\/)orig/, `$1${alias}`);
}
