import ym from 'client/common/components/yandex-metrika';

import { IResponseError } from '../@types/fetch';

import { getErrorCode, getProp } from './helper';

interface IParams {
    internalCode: string | number;
    reqId?: object;
}

export function reachGoal(target?: string, params?: object) {
    if (!target) {
        return;
    }

    ym('reachGoal', target, params);
}

export function reachErrorGoal(goal: string, err: IResponseError[]) {
    const params: IParams = { internalCode: getErrorCode(err, true) };
    const reqId = getProp(err, '0.reqId');

    if (reqId) {
        params.reqId = reqId;
    }

    reachGoal(goal, params);
}

export function setParams(params: object) {
    ym('params', params);
}

/**
 * Отправляет данные в метрику при достижении заданного числа милисекунд
 * @param {String} goalId
 * @param {Number|*} timeout
 */
export function reachTime(goalId: string, timeout: number = 30000) {
    if (!goalId) {
        return;
    }

    setTimeout(() => {
        reachGoal(goalId);
    }, timeout);
}

/**
 * Скролл до конца элемента
 * @param {Object} elem
 * @param {String} goal
 * @param {Function} handler - функция, которая вызовится по достижению
 * @param {number} threshold - с какой части элемент считает увиденным.
 * от 0 до 1, при этом 0 - верхняя граница элемента, 1 - нижняя
 * @returns {Boolean}
 */
/* eslint-disable max-params */
export function detectScrollEnd(
    elem: HTMLDivElement,
    goal: string,
    handler: () => void,
    threshold: number = 1
) {
    const winBottomOffset = window.pageYOffset + window.innerHeight;
    const elemBottomOffset = elem.offsetTop + (elem.clientHeight * threshold);
    const isEndReached = winBottomOffset > elemBottomOffset;

    if (isEndReached) {
        if (goal) {
            reachGoal(goal);
        }

        if (handler) {
            window.removeEventListener('scroll', handler);
        }
    }

    return isEndReached;
}
/* eslint-disable max-params */
