import { throttle } from './throttle';

export function to(options: ScrollToOptions, callback?: () => void) {
    const { behavior, left = 0, top = 0 } = options;

    const onScroll = throttle(handleScroll, 300);

    function handleScroll() {
        const scrollLeft = window.scrollX || document.documentElement.scrollLeft;
        const scrollTop = window.scrollY || document.documentElement.scrollTop;

        if (scrollTop === top && scrollLeft === left) {
            window.removeEventListener('scroll', onScroll);
            callback!();
        }
    }

    if ('scrollBehavior' in document.documentElement.style) {
        window.scrollTo({ behavior, left, top });
    } else {
        window.scrollTo(left, top);
    }

    if (callback) {
        window.addEventListener('scroll', onScroll);
        handleScroll();
    }
}

export function isElementScrolledToEnd(element: HTMLElement, treshold: number = 1) {
    const windowBottomOffset = document.documentElement.scrollTop + window.innerHeight;
    const elementBottomOffset = element.offsetTop + (element.offsetHeight * treshold);

    return windowBottomOffset > elementBottomOffset;
}
