import { IFilter, ISolution, ISolutionSection, TFiltersCategory } from 'client/common/types';
import i18n from 'utils/i18n';

interface IGetTagsParams {
    categories: TFiltersCategory[];
    filter: Pick<ISolutionSection, TFiltersCategory>;
    addSection?: boolean;
}

interface IPatchedFilter extends IFilter {
    category: TFiltersCategory | '';
}

export function getTags(solution: ISolution, params: IGetTagsParams) {
    const { categories, filter, addSection } = params;
    const { section } = solution;

    const tags: IPatchedFilter[] = [];

    // FIXME: убрать проверку на others, когда такие решения переедут в другую секцию
    if (addSection && !['others', '_self'].includes(section)) {
        const sectionTagName = i18n({
            keyset: 'solutions',
            key: section
        });

        tags.push({
            category: '',
            slug: section,
            name: sectionTagName
        });
    }

    categories.forEach(category => {
        const categorySlugs = solution[category] || '';
        const categoryTags = categorySlugs
            .split(',')
            .map((categorySlug: TFiltersCategory) =>
                filter[category].find((el: IFilter) => el && el.slug === categorySlug))
            .filter(Boolean)
            .map<IPatchedFilter>((foundedFilter: IFilter) => ({ ...foundedFilter, category }));

        tags.push(...categoryTags);
    });

    return tags;
}
