export function throttle(func: () => void, ms: number): () => void {
    let isThrottled = false;
    let needCall = false;

    function wrapper() {
        if (isThrottled) {
            needCall = true;

            return;
        }

        func();

        isThrottled = true;
        needCall = false;

        setTimeout(() => {
            isThrottled = false;

            if (needCall) {
                wrapper();
            }
        }, ms);
    }

    return wrapper;
}
