/* eslint complexity: 0 */

const path = require('path');

const BrotliWebpackPlugin = require('brotli-webpack-plugin');
const CompressionWebpackPlugin = require('compression-webpack-plugin');
const ForkTsCheckerPlugin = require('fork-ts-checker-webpack-plugin');
const _ = require('lodash');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');
const webpack = require('webpack');
const cfg = require('yandex-cfg');
const { TsconfigPathsPlugin } = require('tsconfig-paths-webpack-plugin');

const { STATS_OPTIONS } = require('./config');
const { CLIENT_DIR, DIST_DIR, ROOT_DIR, WEBPACK_DIR } = require('./dir');
const { ENV, IS_DEV } = require('./env');
const loaders = require('./loaders');

function createPlatformBundle(platform, index) {
    return [
        IS_DEV && 'css-hot-loader/hotModuleReplacement',
        IS_DEV && `webpack-hot-middleware/client?path=/__webpack_hmr_${index}`,
        path.join(CLIENT_DIR, 'client', 'platforms', platform)
    ].filter(Boolean);
}

function getConfig(lang, index) {
    const normalizedLang = _.snakeCase(lang);
    const vendorsManifestPath = path.join(WEBPACK_DIR, `vendors-manifest-${normalizedLang}.json`);
    // eslint-disable-next-line global-require
    const vendorsManifest = require(vendorsManifestPath);

    // Т.к. все сборки отличаются только переводами, то проверять типы можно только один раз
    const shouldCheckTypes = index === 0;

    return {
        name: `client_${lang}`,
        target: 'web',
        devtool: 'source-map',
        entry: {
            statvalue: createPlatformBundle('statvalue', index),
            promo: createPlatformBundle('promo', index),
            postcard: createPlatformBundle('postcard', index),
            desktop: createPlatformBundle('desktop', index),
            touch: createPlatformBundle('touch.phone', index)
        },
        externals: {
            'react': 'React',
            'react-dom': 'ReactDOM'
        },
        output: {
            filename: `[name].bundle.${lang}.js`,
            library: 'Client',
            libraryTarget: 'var',
            path: path.join(DIST_DIR, 'client'),
            publicPath: '/vda/static2/'
        },
        module: {
            rules: [
                loaders.legoI18N,
                loaders.css.client,
                loaders.typescript.client,
                loaders.file.client,
                loaders.url,
                loaders.svg.client
            ]
        },
        resolve: {
            extensions: ['.js', '.ts', '.tsx'],
            plugins: [
                new TsconfigPathsPlugin({ configFile: path.join(CLIENT_DIR, 'tsconfig.json') })
            ]
        },
        plugins: [
            new webpack.DllReferencePlugin({
                context: ROOT_DIR,
                manifest: vendorsManifest
            }),
            new MiniCssExtractPlugin({
                filename: '[name].bundle.css'
            }),
            !IS_DEV && BrotliWebpackPlugin(),
            !IS_DEV && new CompressionWebpackPlugin(),
            new webpack.DefinePlugin({
                'process.env.NODE_ENV': JSON.stringify(ENV),
                'process.env.BEM_LANG': JSON.stringify(lang)
            }),
            shouldCheckTypes && new ForkTsCheckerPlugin({
                watch: IS_DEV ? [CLIENT_DIR] : undefined,
                tsconfig: path.join(CLIENT_DIR, 'tsconfig.json')
            }),
            IS_DEV && new webpack.HotModuleReplacementPlugin()
        ].filter(Boolean),
        stats: STATS_OPTIONS
    };
}

module.exports = cfg.langs.map(getConfig);
