const MiniCssExtractPlugin = require('mini-css-extract-plugin');
const postcssReporter = require('postcss-reporter');
const cssnano = require('cssnano');
const postcssCustomProperties = require('postcss-custom-properties');
const postcssNested = require('postcss-nested');
const postcssPresetEnv = require('postcss-preset-env');
const themeFold = require('postcss-theme-fold');

const { CSS_VARIABLES_FILE, CSS_LEGO_VARIABLES_FILE } = require('../dir');
const { IS_DEV } = require('../env');

const postcssLoader = {
    loader: 'postcss-loader',
    options: {
        plugins: [
            postcssNested(),
            postcssPresetEnv(),
            !IS_DEV && cssnano({ preset: 'default' }),
            postcssReporter(),
            postcssCustomProperties({ importFrom: CSS_VARIABLES_FILE, preserve: false }),
            themeFold({ themes: [[CSS_LEGO_VARIABLES_FILE]] })
        ].filter(Boolean)
    }
};

const cssLoader = {
    loader: 'css-loader'
};

module.exports = {
    client: {
        test: /\.css$/,
        use: [
            IS_DEV && 'css-hot-loader',
            MiniCssExtractPlugin.loader,
            cssLoader,
            postcssLoader
        ].filter(Boolean)
    },

    ssr: {
        test: /\.css$/,
        loader: 'null-loader'
    }
};
