const { IS_DEV } = require('../env');

const babelOptions = {
    cacheDirectory: IS_DEV,
    presets: [
        [
            '@babel/preset-env',
            {
                loose: true,
                modules: false,
                corejs: '3',
                useBuiltIns: 'entry',
                targets: { ie: '11' }
            }
        ],
        '@babel/preset-typescript',
        '@babel/preset-react'
    ],
    plugins: [
        '@babel/plugin-transform-runtime',
        '@babel/plugin-proposal-optional-chaining',
        '@babel/plugin-proposal-nullish-coalescing-operator',
        ['@babel/plugin-proposal-class-properties', { loose: true }]
    ]
};

module.exports = {
    client: {
        test: /\.tsx?$/,
        exclude: /node_modules/,
        loader: 'babel-loader',
        options: {
            ...babelOptions,
            plugins: [
                ...babelOptions.plugins,
                IS_DEV && 'react-hot-loader/babel'
            ].filter(Boolean)
        }
    },

    ssr: {
        test: /\.tsx?$/,
        exclude: /node_modules/,
        loader: 'babel-loader',
        options: babelOptions
    }
};
