const { join } = require('path');

const { TsconfigPathsPlugin } = require('tsconfig-paths-webpack-plugin');
const webpack = require('webpack');
const nodeExternals = require('webpack-node-externals');
const cfg = require('yandex-cfg');

const { CLIENT_DIR, DIST_DIR } = require('./dir');
const loaders = require('./loaders');

function getConfig(lang) {
    return {
        name: `ssr_bundles_${lang}`,
        target: 'node',
        node: { __dirname: false },
        devtool: 'source-map',
        entry: join(CLIENT_DIR, 'client', 'platforms', 'index.ts'),
        output: {
            filename: `ssr.bundles.${lang}.js`,
            libraryTarget: 'commonjs2',
            path: DIST_DIR,
            publicPath: '/vda/static2/'
        },
        resolve: {
            extensions: ['.js', '.ts', '.tsx'],
            plugins: [
                new TsconfigPathsPlugin({ configFile: './static2/tsconfig.json' })
            ]
        },
        externals: [nodeExternals({
            whitelist: [
                /\.(?!(?:jsx?|json)$).{1,5}$/i,
                /lego-on-react/,
                /@yandex-lego/
            ]
        })],
        module: {
            rules: [
                loaders.legoI18N,
                loaders.css.ssr,
                loaders.typescript.ssr,
                loaders.file.ssr,
                loaders.url,
                loaders.svg.ssr
            ]
        },
        plugins: [
            new webpack.DefinePlugin({
                'process.env.BEM_LANG': JSON.stringify(lang)
            })
        ],
        optimization: { nodeEnv: false },
        stats: 'errors-only'
    };
}

module.exports = cfg.langs.map(getConfig);
