const { join } = require('path');

const BrotliWebpackPlugin = require('brotli-webpack-plugin');
const CompressionWebpackPlugin = require('compression-webpack-plugin');
const _ = require('lodash');
const webpack = require('webpack');
const cfg = require('yandex-cfg');

const { STATS_OPTIONS, VENDORS } = require('./config');
const { DIST_DIR, WEBPACK_DIR } = require('./dir');
const { IS_DEV } = require('./env');
const loaders = require('./loaders');

function getConfig(lang) {
    const normalizedLang = _.snakeCase(lang);

    return {
        target: 'web',
        devtool: 'source-map',
        entry: {
            vendors: VENDORS
        },
        output: {
            library: `[name]_${normalizedLang}_[hash]`,
            filename: `[name]_${normalizedLang}_[hash].js`,
            path: join(DIST_DIR, 'client', '_')
        },
        externals: {
            'react': 'React',
            'react-dom': 'ReactDOM'
        },
        plugins: [
            new webpack.DllPlugin({
                name: `[name]_${normalizedLang}_[hash]`,
                path: join(WEBPACK_DIR, `vendors-manifest-${normalizedLang}.json`)
            }),
            new webpack.DefinePlugin({
                'process.env.BEM_LANG': JSON.stringify(lang)
            }),
            !IS_DEV && new BrotliWebpackPlugin(),
            !IS_DEV && new CompressionWebpackPlugin(),
            IS_DEV && new webpack.HotModuleReplacementPlugin()
        ].filter(Boolean),
        module: {
            rules: [
                loaders.legoI18N
            ]
        },
        stats: STATS_OPTIONS
    };
}

module.exports = cfg.langs.map(getConfig);
