declare module 'yandex-cfg' {
    interface Config {
        server: {
            port: number | string
            hostname: string
        },

        csp: {
            policies: {
                [key: string]: string[]
            }
        },

        comdiUrl: string,

        environment: string
    }

    /* eslint-disable no-use-before-define */
    type RecursivePartial<T> = {
        [P in keyof T]?: RecursivePartial<T[P]>;
        };
    /* eslint-enable no-use-before-define */

    export type AppConfig = RecursivePartial<Config>;

    const config: Config;
    export default config;
}
