import os from 'os';

import { AppConfig } from 'yandex-cfg';

const config: AppConfig = {
    server: {
        port: process.env.QLOUD_HTTP_PORT || 8000,
        hostname: os.hostname()
    },

    csp: {
        policies: {
            'script-src': ['\'self\'', '%nonce%', '*.adroll.com',
                'connect.facebook.net', 'yastatic.net']
        }
    },

    comdiUrl: 'https://yastatic.net/s3/vda/static/comdi/comdi.js',

    environment: process.env.NODE_ENV || 'local'
};

export = config;
