import config from 'yandex-cfg';
import express from 'express';
import expressYandexCsp from 'express-yandex-csp';

import { finalErrorHandler } from './middlewares';
import router from './router';

const viewsDir = './static';

const app = express();

app
    .set('env', config.environment)
    .set('view engine', 'hbs')
    .set('views', viewsDir)

    .disable('x-powered-by')
    .disable('etag')
    .enable('trust proxy')

    .use(expressYandexCsp(config.csp))
    .use(router)
    .use(finalErrorHandler);

export default app;
