from functools import wraps
from typing import List, Callable

from django.utils.decorators import available_attrs

from rest_framework.exceptions import ValidationError
from rest_framework.request import Request


def require_query_params(*params: List[str]) -> Callable:
    def decorator(func: Callable):
        @wraps(func, assigned=available_attrs(func))
        def inner(*args, **kwargs):
            request = args[0] if isinstance(args[0], Request) else args[0].request

            missing_parameters = []

            for param in params:
                if param not in request.query_params:
                    missing_parameters.append(param)

            if missing_parameters:
                raise ValidationError(detail=f'{missing_parameters} query parameters are missing!')

            return func(*args, **kwargs)
        return inner
    return decorator
