from moderation.message_backends import BaseMessageBackend


class StartrekClient:
    def __init__(self, base_url=None, token=None, useragent=None):
        self.base_url = base_url
        self.token = token
        self.useragent = useragent
        self.queue = None

        self._st = None

    @property
    def st(self):
        if not self._st:
            # Полностью ленивая инициализация, чтобы избежать side-эффектов
            # импортирования django настроек, иначе ломается django-moderation

            from django.conf import settings
            from startrek_client import Startrek

            self.queue = settings.STARTREK_QUEUE

            kwargs = dict(
                base_url=self.base_url or settings.STARTREK_BASE_URL,
                token=self.token or settings.STARTREK_TOKEN,
                useragent=self.useragent or settings.STARTREK_USERAGENT
            )

            self._st = Startrek(**kwargs) if kwargs['token'] else None

        return self._st


class StartrekMessageBackend(BaseMessageBackend):
    def send(self, subject='', message='', **kwargs):
        if not client.st:
            return

        client.st.issues.create(
            queue=client.queue,
            summary=subject,
            description=message,
            storyPoints=1
        )


client = StartrekClient()
