from django.core.management.base import BaseCommand
from django.db import transaction

from .migrator import models
from .migrator.bunker import client as bunker
from .migrator.migrate import migrate

from commerce.adv_backend.backend.models import City, CompanyCertificate


class Command(BaseCommand):
    help = 'Migrates data from bunker to database'

    def handle(self, *args, **options):
        # Получаем все агенства, без числового суффикса,
        # чтобы не дублировать Китайские агенства
        agencies = bunker.fetch(r'agencies/.*?/.*(?<!_\d)')

        with transaction.atomic():
            for agency in agencies:
                company = migrate(agency, models.Company())

                for i, address in enumerate(agency['addresses']):
                    migrate(address, models.CompanyOffice(company=company, is_main=i == 0))

        # Проставляем приоритет Москве и Санкт-Петербургу
        moscow = City.objects.get(geo_id=213)
        moscow.display_priority = 1002
        moscow.save(update_fields=['display_priority'])

        piter = City.objects.get(geo_id=2)
        piter.display_priority = 1001
        piter.save(update_fields=['display_priority'])

        # Проставляем сертификату по Директу флаг is_regional
        direct_cert = CompanyCertificate.objects.get(code='direct')
        direct_cert.is_regional = True
        direct_cert.save(update_fields=['is_regional'])
