from django.core.management.base import BaseCommand
from django.db import transaction
from django.contrib.auth.models import User

from commerce.adv_backend.backend.models import UserRole


class Command(BaseCommand):
    help = 'Create superuser role for local user'

    def handle(self, *args, **options):
        with transaction.atomic():
            user = User.objects.all()[0]

            UserRole.objects.create(user=user, group='common', role='superuser')
