import re

from django.conf import settings

from .session import SessionWithBaseUrl


class Bunker:
    def __init__(self, base_url, project, version):
        self.project = project
        self.version = version
        self.session = SessionWithBaseUrl(base_url)
        self._tree = None

    @property
    def tree(self):
        if not self._tree:
            params = {'node': self.project, 'version': self.version}

            response = self.session.get('tree', params=params)

            self._tree = response.json()

        return self._tree

    def cat(self, node: str):
        params = {'node': node, 'version': self.version}

        response = self.session.get('cat', params=params)

        return response.json()

    def fetch(self, path_pattern: str, deleted=False, disabled=False, saved=True) -> list:
        path_pattern = f'^{self.project}/{path_pattern}$'

        result = []

        for elem in self.tree:
            node = elem['fullName'].strip('/')

            if not deleted and elem.get('isDeleted'):
                continue

            if saved and not elem.get('saveDate'):
                continue

            if not re.match(path_pattern, node):
                continue

            node_value = self.cat(node)

            if not disabled and node_value.get('disabled'):
                continue

            result.append(node_value)

        return result


client = Bunker(
    base_url=settings.BUNKER_BASE_URL,
    project=settings.BUNKER_PROJECT,
    version=settings.BUNKER_VERSION
)
