import re

import html2text


# Игнорируем html entities
for key in html2text.config.UNIFIABLE:
    html2text.config.UNIFIABLE[key] = f'&{key};'


parser = html2text.HTML2Text()
parser.ignore_images = True


def html_to_text(value):
    markdown = (
        parser
        .handle(value)
        .strip()
    )

    markdown = re.sub('\[\]\([\s\S]+?\)', '', markdown)  # Вырезаем ссылки без текста (которые оборачивали картинки)
    markdown = re.sub('\[([\s\S]+?)\]\(([\s\S]+?)\)',
                      r'<a href="\2" target="_blank" rel="noopener noreferrer">\1</a>',
                      markdown)  # markdown2html

    return markdown
