from requests import Session


class SessionWithBaseUrl(Session):
    def __init__(self, base_url):
        super().__init__()

        self.base_url = base_url

    def request(self, method, path, *args, **kwargs):
        url = self.base_url + path

        return super().request(method, url, *args, **kwargs)
