from django.http.response import HttpResponseRedirect
from django.http.request import HttpRequest

from django_yauth.middleware import YandexAuthBackendMiddleware
from django_yauth.util import get_current_url, get_passport_url


class AuthRequiredMiddleware(YandexAuthBackendMiddleware):
    EXCEPTION_PREFIXES = ('/idm/', '/ping')

    def process_request(self, request: HttpRequest):
        if any(request.path.startswith(prefix) for prefix in self.EXCEPTION_PREFIXES):
            return

        super().process_request(request)

        if request.yauser and request.yauser.is_authenticated():
            return

        # TODO: Кажется, что эту логику можно получить встроенной YandexAuthMiddleware, правильно указав настройки
        # ADVDEV-1482
        retpath = get_current_url(request)
        passport_url = get_passport_url('create', request=request, retpath=retpath)

        return HttpResponseRedirect(redirect_to=passport_url)
