# Generated by Django 2.2.7 on 2019-11-25 06:30

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('backend', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='City',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('geo_id', models.PositiveIntegerField(help_text='https://geoadmin.yandex-team.ru/', unique=True, verbose_name='Идентификатор из геобазы')),
                ('name', models.CharField(max_length=128, unique=True, verbose_name='Название')),
            ],
            options={
                'verbose_name': 'Город',
                'verbose_name_plural': 'Города',
            },
        ),
        migrations.CreateModel(
            name='Company',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address', models.CharField(blank=True, max_length=256, verbose_name='Адрес')),
                ('phone', models.CharField(blank=True, max_length=15, validators=[django.core.validators.RegexValidator(regex='^\\+?1?\\d{9,15}$')], verbose_name='Номер телефона')),
                ('map', models.CharField(choices=[('yandex', 'Яндекс.Карты'), ('osm', 'OpenStreetMap')], max_length=6, verbose_name='Тип карты')),
                ('latitude', models.DecimalField(decimal_places=6, max_digits=9, verbose_name='Широта')),
                ('longitude', models.DecimalField(decimal_places=6, max_digits=9, verbose_name='Долгота')),
                ('map_zoom', models.IntegerField(verbose_name='Масштаб карты')),
                ('name', models.CharField(max_length=128, unique=True, verbose_name='Название')),
                ('logo', models.URLField(verbose_name='Ссылка на логотип')),
                ('min_budget', models.PositiveIntegerField(blank=True, null=True, verbose_name='Минимальный бюджет рекламной кампании')),
                ('site', models.URLField(verbose_name='Сайт')),
                ('email', models.EmailField(blank=True, max_length=254, null=True, unique=True, verbose_name='Электронная почта')),
                ('representative', models.CharField(max_length=30, verbose_name='Логин главного представителя')),
                ('description', models.TextField(blank=True, verbose_name='Описание компании')),
            ],
            options={
                'verbose_name': 'Компания-партнёр',
                'verbose_name_plural': 'Компании-партнёры',
            },
        ),
        migrations.CreateModel(
            name='CompanyCertificate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=12, unique=True, verbose_name='Код')),
                ('name', models.CharField(max_length=50, unique=True, verbose_name='Человекочитаемое название')),
            ],
            options={
                'verbose_name': 'Сертификат',
                'verbose_name_plural': 'Сертификаты',
            },
        ),
        migrations.CreateModel(
            name='CompanyType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=12, unique=True, verbose_name='Код')),
                ('name', models.CharField(max_length=50, unique=True, verbose_name='Человекочитаемое название')),
            ],
            options={
                'verbose_name': 'Тип компании',
                'verbose_name_plural': 'Типы компаний',
            },
        ),
        migrations.CreateModel(
            name='Country',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('geo_id', models.PositiveIntegerField(help_text='https://geoadmin.yandex-team.ru/', unique=True, verbose_name='Идентификатор из геобазы')),
                ('name', models.CharField(max_length=128, unique=True, verbose_name='Название')),
            ],
            options={
                'verbose_name': 'Страна',
                'verbose_name_plural': 'Страны',
            },
        ),
        migrations.CreateModel(
            name='Office',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address', models.CharField(blank=True, max_length=256, verbose_name='Адрес')),
                ('phone', models.CharField(blank=True, max_length=15, validators=[django.core.validators.RegexValidator(regex='^\\+?1?\\d{9,15}$')], verbose_name='Номер телефона')),
                ('map', models.CharField(choices=[('yandex', 'Яндекс.Карты'), ('osm', 'OpenStreetMap')], max_length=6, verbose_name='Тип карты')),
                ('latitude', models.DecimalField(decimal_places=6, max_digits=9, verbose_name='Широта')),
                ('longitude', models.DecimalField(decimal_places=6, max_digits=9, verbose_name='Долгота')),
                ('map_zoom', models.IntegerField(verbose_name='Масштаб карты')),
                ('certificated', models.BooleanField(default=False, verbose_name='Сертифицирован')),
                ('city', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='backend.City', verbose_name='Город')),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='backend.Company', verbose_name='Компания')),
                ('country', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='backend.Country', verbose_name='Страна')),
            ],
            options={
                'verbose_name': 'Филиал',
                'verbose_name_plural': 'Филиалы',
            },
        ),
        migrations.CreateModel(
            name='Tld',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.CharField(max_length=6, verbose_name='Значение')),
            ],
            options={
                'verbose_name': 'Домен верхнего уровня',
                'verbose_name_plural': 'Домены верхнего уровня',
            },
        ),
        migrations.DeleteModel(
            name='Agency',
        ),
        migrations.AddField(
            model_name='company',
            name='certificates',
            field=models.ManyToManyField(blank=True, to='backend.CompanyCertificate', verbose_name='Сертификаты'),
        ),
        migrations.AddField(
            model_name='company',
            name='city',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='backend.City', verbose_name='Город'),
        ),
        migrations.AddField(
            model_name='company',
            name='country',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='backend.Country', verbose_name='Страна'),
        ),
        migrations.AddField(
            model_name='company',
            name='tld',
            field=models.ManyToManyField(to='backend.Tld', verbose_name='Где показывать'),
        ),
        migrations.AddField(
            model_name='company',
            name='types',
            field=models.ManyToManyField(to='backend.CompanyType', verbose_name='Типы'),
        ),
    ]
