from django.db.models import F


class BudgetOrderMixin:
    def order_queryset(self, queryset):
        budget_query_order = self.request.query_params.get('budget_order')

        if budget_query_order:
            budget_db_order = F('direct_budget').asc(nulls_last=True)

            if budget_query_order == 'desc':
                budget_db_order = F('direct_budget').desc(nulls_last=True)

            queryset = queryset.order_by(budget_db_order)

        return queryset
