from django.conf import settings
from django.core.exceptions import ValidationError


class TranslationRequiredMixin:
    def clean_fields(self, exclude=None):
        super().clean_fields(exclude)

        error_tab = settings.DB_LANGUAGES[0]

        errors = dict()

        for field in self.translation_fields:
            required_field = field in self.required_translation_fields

            if required_field and not any(getattr(self, f'{field}_{lang}') for lang in settings.DB_LANGUAGES):
                errors[f'{field}_{error_tab}'] = 'Поле не заполнено ни на одном из языков!'

        if errors:
            raise ValidationError(errors)
