from django.contrib.auth.models import User

from rest_framework.permissions import BasePermission

from commerce.adv_backend.backend import models


class ViewSuperuserPermissionMixin(BasePermission):
    def _get_user(self, request):
        internal_login = request.yauser.login

        return User.objects.get(username=internal_login)

    def has_permission(self, request, view):
        return (
            models.UserRole.objects
            .filter(
                group='common',
                role='superuser',
                user=self._get_user(request)
            )
            .exists()
        )
