from django.db import models


class EnumModel(models.Model):
    code = models.CharField(
        verbose_name='Код',
        unique=True,
        max_length=12
    )
    name = models.CharField(
        verbose_name='Человекочитаемое название',
        unique=True,
        max_length=50,
        blank=True
    )

    class Meta:
        abstract = True

    def __str__(self):
        return self.name
