from django.db import models


class GeoModel(models.Model):
    geo_id = models.PositiveIntegerField(
        verbose_name='Идентификатор из геобазы',
        help_text='https://geoadmin.yandex-team.ru/',
        unique=True
    )
    name = models.CharField(
        verbose_name='Название',
        unique=True,
        max_length=128,
        blank=True
    )

    class Meta:
        abstract = True

    def __str__(self):
        return self.name
