from django.db import models


class ModeratedModel(models.Model):
    proposed_by = models.CharField(
        verbose_name='Предложено пользователем',
        max_length=150,
        blank=True
    )
    is_approved = models.BooleanField(
        verbose_name='Принято ли изменение модератором',
        blank=True,
        null=True
    )

    class Meta:
        abstract = True
