from django.db import models

from .abstract import GeoModel
from ..mixins import TranslationRequiredMixin


class City(TranslationRequiredMixin, GeoModel):
    preposition = models.CharField(
        verbose_name='Предлог',
        max_length=4,
        blank=True
    )
    name_prepositional = models.CharField(
        verbose_name='Название в предложном падеже',
        unique=True,
        max_length=128,
        blank=True
    )
    display_priority = models.PositiveSmallIntegerField(
        verbose_name='Приоритет',
        help_text='Используется для сортировки городов и офисов',
        default=0
    )
    country = models.ForeignKey(
        verbose_name='Страна',
        to='Country',
        on_delete=models.PROTECT
    )

    translation_fields = ('name', 'preposition', 'name_prepositional')
    required_translation_fields = ('name', 'preposition', 'name_prepositional')

    class Meta:
        verbose_name = 'Город'
        verbose_name_plural = 'Города'

        indexes = [
            models.Index(fields=['geo_id'])
        ]

        ordering = [
            'country__name',
            '-display_priority',
            'name'
        ]
