from django.db import models

from .abstract import EnumModel


class CompanyCertificate(EnumModel):
    preposition = models.CharField(
        verbose_name='Предлог',
        max_length=4,
        blank=True
    )
    name_prepositional = models.CharField(
        verbose_name='Название в предложном падеже',
        unique=True,
        max_length=128,
        blank=True
    )
    is_regional = models.BooleanField(
        verbose_name='Региональная принадлежность',
        default=False,
        blank=True
    )

    translation_fields = ('name', 'preposition', 'name_prepositional')
    required_translation_fields = ('name', 'preposition', 'name_prepositional')

    class Meta:
        verbose_name = 'Сертификат'
        verbose_name_plural = 'Сертификаты'
