from django.db import models


class CompanyRepresentative(models.Model):
    company = models.ForeignKey('Company', on_delete=models.CASCADE)
    representative = models.ForeignKey('ExternalUser', on_delete=models.CASCADE)
    is_main = models.BooleanField('Главный ли представитель', default=False)

    class Meta:
        verbose_name = 'Представитель'
        verbose_name_plural = 'Представители'

    def __str__(self):
        return self.representative.username
