from django.db import models

from .abstract import GeoModel
from ..mixins import TranslationRequiredMixin


class Country(TranslationRequiredMixin, GeoModel):
    preposition = models.CharField(
        verbose_name='Предлог',
        max_length=4,
        blank=True
    )
    name_prepositional = models.CharField(
        verbose_name='Название в предложном падеже',
        unique=True,
        max_length=128,
        blank=True
    )

    translation_fields = ('name', 'preposition', 'name_prepositional')
    required_translation_fields = ('name', 'preposition', 'name_prepositional')

    class Meta:
        verbose_name = 'Страна'
        verbose_name_plural = 'Страны'

        indexes = [
            models.Index(fields=['geo_id'])
        ]

        ordering = ['name']
