from django.db import models


class ExternalUser(models.Model):
    username = models.CharField(
        verbose_name='Яндекс.Логин',
        max_length=150,
        unique=True
    )

    class Meta:
        verbose_name = 'Внешний пользователь'
        verbose_name_plural = 'Внешние пользователи'

        indexes = [
            models.Index(fields=['username'])
        ]

        ordering = ['username']

    def __str__(self):
        return self.username
